﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport spadek sprzedaży</title>

    <script runat="server"> 

        public class ParametryContext : ContextBase {
            public ParametryContext(Context cx)
                : base(cx) {
            }

            [Soneta.Tools.Priority(5)]
            [DefaultWidth(150)]
            [Soneta.Business.Required()]
            public Magazyn Magazyn {
                get;
                set;
            }
            
            private FromTo _okresA = Date.Now.Month - 1 == 0 ? FromTo.Month(Date.Now.Year - 2, 12) : FromTo.Month(Date.Now.Year - 1, Date.Now.Month - 1);
            [Soneta.Tools.Priority(10)]
            [Caption("Okres A")]
            [DefaultWidth(150)]
            public Soneta.Types.FromTo OkresA {
                get {
                    return this._okresA;
                }
                set {
                    this._okresA = value;
                }
            }

            [Soneta.Tools.Priority(20)]
            [DefaultWidth(150)]
            public decimal KwotaOd {
                get;
                set;
            }
            
            private FromTo _okresB = Date.Now.Month - 1 == 0 ? FromTo.Month(Date.Now.Year -1, 12) : FromTo.Month(Date.Now.Year, Date.Now.Month - 1);
            
            [Soneta.Tools.Priority(30)]
            [Caption("Okres B")]
            [DefaultWidth(150)]
            public Soneta.Types.FromTo OkresB {
                get {
                    return this._okresB;
                }
                set {
                    this._okresB = value;
                }
            }

            [Soneta.Tools.Priority(40)]
            [DefaultWidth(150)]
            public decimal KwotaDo {
                get;
                set;
            }

            
            //private bool _ignorujZaliczkowe = true;
            //[Soneta.Tools.Priority(50)]
            //public bool IgnorujZaliczkowe {
            //    get {
            //        return this._ignorujZaliczkowe;
            //    }
            //    set {
            //        this._ignorujZaliczkowe = value;
            //        OnChanged(EventArgs.Empty);
            //    }
            //}
                        
        }

        private enum OkresAB{
            A, B
        }
        
        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }
 
        public class Total : IComparable {
                        
            readonly Kontrahent kontrahent;
            
            decimal nettoA = 0;
            decimal nettoB = 0;
            decimal nettoBmA = 0;
            Percent nettoBmAwP = Percent.Zero;                        
            
            public Total(Kontrahent kontrahent) {
                this.kontrahent = kontrahent;
            }
            
            
            public void AddA(DokumentHandlowy dokument) {                
                nettoA += dokument.Suma.Netto;
                PrzeliczRoznice();
            }
            
            public void AddB(DokumentHandlowy dokument) {
                nettoB += dokument.Suma.Netto;
                PrzeliczRoznice();
            }

            public void PrzeliczRoznice() {
                nettoBmA = nettoB - nettoA;
                nettoBmAwP = nettoA != 0m ? new Percent(nettoBmA / nettoA) : new Percent(1m);
            }  
            
            public Kontrahent Kontrahent {
                get { return kontrahent; }
            }
            
            public decimal NettoA {
                get { return nettoA; }
            }
            
            public decimal NettoB {
                get { return nettoB; }
            }

            public decimal RoznicaNetto {
                get { return nettoBmA; }
            }
            public Percent RoznicaNettoP {
                get { return nettoBmAwP; }
            }
                                    
            public int CompareTo(object obj) {
                Total t = (Total)obj;
                return Kontrahent.Nazwa.CompareTo(t.Kontrahent.Nazwa);
            }
        }

        Soneta.Business.View GetView(ParametryContext parametry, Kontrahent[] kontrahenci, OkresAB okres) {
            HandelModule hm = HandelModule.GetInstance(parametry);
            
            SubTable st = hm.DokHandlowe.WgMagazyn[parametry.Magazyn];
            st = new SubTable(st, okres == OkresAB.A ? parametry.OkresA : parametry.OkresB);
            Soneta.Business.View view = st.CreateView();

            RowCondition cond = new FieldCondition.In("Kontrahent", kontrahenci);
            cond &= new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.Sprzedaż) & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaSprzedaży);

            view.Condition &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);
            // view.Condition &= DokHandlowe.UtwórzCondition("", pars.Stan); ???
            
            view.Condition = cond;
            view.FilterCondition += new ConditionHandler(view_FilterCondition);
            return view;
        }
        
        private void view_FilterCondition(object sender, ConditionEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;
            if (dok.Definicja.GetObjectRight() == AccessRights.Denied)
                args.Accepted = false;
        }

        void OnContextLoad(Object sender, EventArgs args) {

            if (Parametry.Magazyn == null)
            {
                throw new ArgumentException("Nie wybrano magazynu!");
            }

            if (Parametry.OkresA.From >= Parametry.OkresB.From
                || Parametry.OkresA.To >= Parametry.OkresB.From)
            {
                throw new ArgumentException("Niepoprawne okresy!");
            }
                              
            ReportHeader.Title += "|Magazyn: <strong>" + Parametry.Magazyn + "</strong>";
            ReportHeader.Title += "|OkresA: <strong>" + Parametry.OkresA + "</strong>";
            ReportHeader.Title += "|Kwota od (netto): <strong>" + Parametry.KwotaOd + "</strong>";
            ReportHeader.Title += "|OkresB: <strong>" + Parametry.OkresB + "</strong>";
            ReportHeader.Title += "|Kwota do (netto): <strong>" + Parametry.KwotaDo + "</strong>";
            
            
            Kontrahent[] rows = (Kontrahent[])dc[typeof(Kontrahent[])];
            
            Soneta.Business.View viewA = GetView(Parametry, rows, OkresAB.A);
            Soneta.Business.View viewB = GetView(Parametry, rows, OkresAB.B);                       
                        
            Hashtable result = new Hashtable();
            
            foreach (DokumentHandlowy dokument in viewA) 
            {
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;

                //if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;                
                //if (!Parametry.OkresA.Contains(dokument.Data) && !Parametry.OkresB.Contains(dokument.Data)) continue;

                Total t = (Total)result[dokument.Kontrahent];
                if (t == null) 
                {
                    t = new Total(dokument.Kontrahent);
                    result.Add(t.Kontrahent, t);
                }
                t.AddA(dokument);                           
            }

            foreach (DokumentHandlowy dokument in viewB)
            {
                if (dokument.Anulowany) continue;
                if (dokument.Definicja.DuplikatWartosci) continue;

                //if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;                
                //if (!Parametry.OkresA.Contains(dokument.Data) && !Parametry.OkresB.Contains(dokument.Data)) continue;

                Total t = (Total)result[dokument.Kontrahent];
                if (t == null)
                {
                    t = new Total(dokument.Kontrahent);
                    result.Add(t.Kontrahent, t);
                }
                t.AddB(dokument);
            }
                        
            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;            
        }

        protected void Grid_BeforeRow(object sender, RowEventArgs args) {
            Total t = args.Row as Total;
            if (t != null)
            {
                if (t.NettoA < Parametry.KwotaOd || t.NettoB > Parametry.KwotaDo)
                    args.VisibleRow = false;
            }
        }
        
</script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true">
    </ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" Title="Raport - spadek sprzedaży|</STRONG>" runat="server"></eb:ReportHeader>

    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" OnBeforeRow="Grid_BeforeRow">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn Width="25" DataMember="Kontrahent.Kod" Caption="Kontrahent~Kod" NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>            
            <ea:GridColumn DataMember="Kontrahent.Nazwa" Caption="Kontrahent~Nazwa" NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>            
            <ea:GridColumn Width="12" Align="Right" DataMember="NettoA" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres A~Netto"></ea:GridColumn>
            <ea:GridColumn Width="12" Align="Right" DataMember="NettoB" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres B~Netto"></ea:GridColumn>
            <ea:GridColumn Width="12" Align="Right" DataMember="RoznicaNetto" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica netto~wartość"></ea:GridColumn>
            <ea:GridColumn Width="12" Align="Right" DataMember="RoznicaNettoP" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica netto~%"></ea:GridColumn>
        </Columns>
    </ea:Grid>
    <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
    </eb:ReportFooter>
    </form>
</body>
</html>

